/*
 * HTML5 ✰ Boilerplate
 * Site or application scripts.
 * Author: Simon Woodhead
 *
 * Utilizes markup-based unobtrusive comprehensive DOM-ready execution.
 * http://paulirish.com/2009/markup-based-unobtrusive-comprehensive-dom-ready-execution/
 * http://www.viget.com/inspire/extending-paul-irishs-comprehensive-dom-ready-execution/
 */

/*global ACTIVITIES:true, $:true, PluginDetect:true, getUrlParameters:true, activities:true, SyntaxHighlighter:true, ko:true, UTIL:true*/

ACTIVITIES = {
    common: {
        init: function () {
            // application-wide code
            "use strict";
        }
    },
    home: {
        init: function () {
            // controller-wide code
            "use strict";
        },
        activity: function () {
            if ($.client.os === 'Mac') {
              $('#help-link').attr('href', 'http://www.autograph-maths.com/activities/mac/help.html');
            };
                
			$('.autograph-player-file').agg();            
		}        
    }

};

UTIL = {
    exec: function (controller, actionparam) {
        "use strict";
        var ns = ACTIVITIES,
            action = (actionparam === undefined) ? 'init' : actionparam;
        if (controller !== '' && ns[controller] && typeof ns[controller][action] === 'function') {
            ns[controller][action]();
        }
    },
    init: function () {
        "use strict";
        var body = document.body,
            controller = body.getAttribute('data-controller'),
            action = body.getAttribute('data-action');

        UTIL.exec('common');

        UTIL.exec(controller);
        UTIL.exec(controller, action);
    }
};

$(document).ready(UTIL.init);